{smcl}
{* *! version 1.0.0 5aug2014}{...}
{title:Title}

{phang}
{bf:dsimih create} {hline 2} Obtain SIRFs and SFEVDs after {help svarih}


{marker syntax}{...}
{title:Syntax}

{pstd}
After {cmd:svarih {ul:bac}ciocchi}, {cmd:svarih {ul:bfa}nelli} and {cmd:svarih {ul:llu}tkepohl}:

{p 8 22 2}
{cmd:dsimih} {opt cr:eate} [{cmd:,} {it:options}]

{synoptset 32 tabbed}{...}
{synopthdr:options}
{synoptline}
{syntab:Main}
{synopt:{opt reg:imes(rgmlist)}}generate results for all regime encodings in {it:rgmlist}; default: all regimes{p_end}
{synopt:{opt st:ep(#)}}set forecast horizon to {it:#}; default is {cmd:step(8)}{p_end}
{synopt:{opt nose}}do not calculate standard errors{p_end}
{synopt:{cmdab:sav:ing(}{it:{help filename}}[{cmd:, replace}]{cmd:)}}save results to file {it:filename}{p_end}

{syntab:Bootstrap}
{synopt:{opt bs}}obtain standard errors from residual bootstrap{p_end}
{synopt:{opt bsp}}obtain standard errors from parametric bootstrap{p_end}
{synopt:{opt r:eps(#)}}use {it:#} bootstrap replications; there is no default value{p_end}
{synopt:{cmdab:bsa:ving(}{it:{help filename}}[{cmd:, replace}]{cmd:)}}save bootstrap results in {it:filename}{p_end}
{synopt:{opt bsbm:at(matname)}}store coefficient estimates from bootstrap replications in matrix {it:matname}{p_end}
{synopt:{opt nod:ots}}do not display "{cmd:.}" for each bootstrap replication or for each {it:step} of asymptotic standard error calculations{p_end}
{synopt:{opt nomax:opts}}use default {it:maximize} options in bootstrap, even if estimates were obtained using different settings{p_end}
{synopt:{opt fromb}}use estimates as starting values for bootstrap optimizations{p_end}
{synopt:{opt v:erbose}}display optimization output for all bootstrap replications{p_end}
{synopt:{opt not:able}}do not show coefficient tables of bootstrap replications when option {opt verbose} is used{p_end}
{synoptline}
{p2colreset}{...}

{p 4 6 2}
The default is to use asymptotic standard errors if no options are specified.{p_end}


{marker description}{...}
{title:Description}

{pstd}
{opt dsimih create} calculates structural impulse-response functions and structural forecast error variance decompositions after {help svarih}.
Results are stored in {cmd:e()} by default, among the results from {cmd:svarih} estimation.

{pstd}
Once you have created a set of {cmd:dsimih} results, use {cmd:dsimih} subcommands other than {cmd:create} to analyze them.


{marker abbreviations}{...}
{title:Abbreviations, definitions, notation, syntax elements}

{pstd}
This help entry uses terminology defined in {help svarih##abbreviations:svarih} and {help dsimih##abbreviations:dsimih}.


{marker options}{...}
{title:Options}

{dlgtab:Main}

{phang}
{opt reg:imes(rgmlist)} enumerates the regimes in their numerical encoding for which SIRFs and SFEVDs shall be created.
The default is to create results for all regimes in the {cmd:svarih} estimation.

{phang}
{opt st:ep(#)} specifies the step (forecast horizon); the default is eight periods.

{phang}
{opt nose} specifies that no standard errors be calculated.
Asymptotic standard errors are the default.
See options {opt bs} and {opt bsp} for bootstrap standard errors.
Note that options {opt nose}, {opt bs} and {opt bsp} are mutually exclusive alternatives.

{phang}
{cmdab:sav:ing(}{it:{help filename}}[{cmd:, replace}]{cmd:)} saves the DS results as a {help dsimih_etodta##dsimihfiles:dsimih file}.
You can choose to preserve results this way in addition to the results saved by {cmd:dsimih create} in {cmd:e()}.
If your maximum {help matsize} setting is too small for DS results, you must specify the {opt saving()} option.

{phang2}
    If {it:filename} is specified without an extension, {opt .dta} is assumed.

{dlgtab:Bootstrap}

{phang}
{opt bs} specifies that standard errors be calculated by a residual bootstrap.
Note that options {opt nose}, {opt bs} and {opt bsp} are mutually exclusive alternatives.

{phang}
{opt bsp} specifies that standard errors be calculated via a multivariate-normal parametric bootstrap.
Note that options {opt nose}, {opt bs} and {opt bsp} are mutually exclusive alternatives.

{phang}
The following options are relevant only if {opt bs} or {opt bsp} is specified.

{phang2}
    {opt r:eps(#)} specifies the number of bootstrap replications to be performed.
    Since there is no default value, you must specify this options when you are bootstrapping standard errors.
    The minimum of # is 3 which is obviously too small a number to produce sensible results.
    Nevertheless, using a small number may be useful when learning the usage of {cmd:dsimih create}.

{phang2}
    {cmdab:bsa:ving(}{it:filename}[{cmd:, replace}]{cmd:)} specifies that the bootstrap replications be saved in file {it:filename}.
    {it:filename} is a regular Stata data file that can be loaded later using {helpb use}.
    If {it:filename} is specified without an extension, {opt .dta} is assumed.

{phang2}
{opt bsbm:at(matname)} saves the coefficient estimates from successful bootstrap replications in matrix {it:matname}.
If matrix {it:matname} already exists, it will get overwritten.
If the number of requested replications from options {opt reps()} is larger than your current {help matsize} setting, the option is ignored in the sense that after {cmd:dsimih create} finishes, matrix {it:matname} will not exist.

{phang2}
    {opt nod:ots} specifies that dots not be displayed each time {opt dsimih create} performs a bootstrap replication.
    It also suppresses the output of dots for each forecast step when calculating asymptotic standard errors.

{pmore2}
    In the case of bootstrap standard errors, usage of this option is discouraged since {cmd:dsimih create} displays characters other than dots for replications that are not counted as being successful.
    It displays a "{cmd:f}" for a replication that failed.
    This might be caused, for example, by infeasible starting values.
    Furthermore, a "{cmd:n}" is displayed if estimates were obtained for a particular replication, but the last ML optimization and/or the GLS iteration did not terminate with the declaration of convergence,
    and a "{cmd:i}" is displayed if estimation went through but parameter estimates did not pass the local identification check.
    The local identification check is only performed for {cmd:svarih bacchiocchi} and {cmd:svarih bfanelli}.

{pmore2}
    Replications are only classified as being successful if a dot is displayed.
    In all other cases the replication is discarded and does not enter the calculation of bootstrap standard errors.

{phang2}
    {opt nomax:opts} applies default maximization options for bootstrap maximum likelihood optimizations as described in {manhelp maximize R}.
    If you do not use this option, {cmd:dsimih create} applies the same maximization options that were used to obtain the {cmd:svarih} estimates.
    For example, if you obtained {cmd:svarih} estimates by switching between the NR and DFP algorithms, the omission of {opt nomaxopts} will apply the same procedure when performing estimation based on the bootstrap samples.
    If you use {opt nomaxopts}, the optimization will only be based on the {help maximize} default, which is the NR algorithm.

{pmore2}
    Note that options {opt nomaxopts} is only concerns the ML optimization.
    If the {cmd:svarih} subcommand in question has a nested GLS procedure, GLS optimization settings in the bootstrap are always identical to the ones used in estimation.

{phang2}
    {opt fromb} will feed the estimated parameter values from {cmd:svarih} as starting values into the bootstrap estimations.
    The default is to use the starting values that were used in obtaining {cmd:svarih} estimates.

{phang2}
    {opt v:erbose} will display the optimization iteration output for each bootstrap replication.

{phang2}
{opt not:able} does not display the coefficient estimates for each bootstrap replication.
The default is to display these tables if option {opt verbose} is used.
If option {opt verbose} is not used, option {opt notable} has no effect.


{marker remarks}{...}
{title:Remarks}

{pstd}
Remarks are presented under the following headings:

    {help dsimih_create##calculated:Calculated statistics, standard errors and error bands}
    {help dsimih_create##treatmentofgaps:Treatment of gaps}
    {help dsimih_create##replacingexistingresults:Replacing existing results}
    {help dsimih_create##matsizeissues:Matsize issues}
    {help dsimih_create##estimationdatasetrequirements:Estimation data set requirements}
    {help dsimih_create##computationalissues:Computational issues}
    {help dsimih_create##settingtheseed:Setting the seed}

{marker calculated}{...}
{title:Calculated statistics, standard errors and error bands}

{pstd}
Statistics calculated are SIRFs and SFEVDs.
They are calculated for each requested regime separately.
Within each regime, calculations are performed in an analogous fashion to {manlink TS irf create} but adjusted for the IH setting.
The basic principle is to obtain {it:conditional} SIRFs and SFEVDs assuming that one is and stays within one regime.

{pstd}
There are three different ways of obtaining error bands.
The default one is to use bands based on asymptotic standard errors.
Calculations differ slightly across {cmd:svarih} methods.

{pstd}
The second choice is option {opt bsp} which applies a parametric bootstrap or option {opt bs} which applies a residual-based bootstrap.
For each bootstrap estimate of the coefficients, {cmd:dsimih create} calculates an SIRF/SFEVD profile.
From these profiles, it calculates the standard error for each step.
The distribution at each step is taken to be normal.

{pstd}
When you use the above methods, you can make full use of the capabilities of {cmd:dsimih table} and {cmd:dsimih graph}.
They use the calculated standard errors to generate error bands.

{pstd}
The third method of obtaining error bands is only useful if you are an advanced Stata user.
In consists in using option {opt bs} or {opt bsp} in combination with option {opt bsaving()}.
The latter saves the results for each replication in an output file.
That is, for each replication you can recover the SIRF/SFEVD profile from the saved file.
From this you can generate, for each step in the SIRF/SFEVD horizon, say, the
3rd and 97th percentiles.
This will generate asymmetric bands.
With this method, you cannot make use of the graphing capabilities of {cmd:dsimih}.
You will have to draw all graphs by yourself.
The data for the error bands to be used in these graphs is based on the output file of option {opt bsaving()}.

{marker treatmentofgaps}{...}
{title:Treatment of gaps}

{pstd}
Applying a bootstrap in order to calculate SIRF/SFEVD standard errors involves the simulation of the dependent variables.
To make the simulation of dependent variables in a recursive (dynamic) system possible when there are gaps in the
data, {opt dsimih create} conditions on initial values of the dependent variables for each gap that occurs in the data.
You must make your own judgement as to whether this is tenable within the particular setting that you are working in.

{marker replacingexistingresults}{...}
{title:Replacing existing results}

{pstd}
In general, new results generated by {cmd:dsimih create} are merged with existing DS results.
For example, if you are creating results for regimes 1 and 4 and results for regime 2 already exist, results for regimes 1, 2, 4 will be available after you run {cmd:dsimih create}.

{pstd}
It may happen that you want to modify existing DS results for a specific {it:rgmlist}.
This makes sense in the following situations:

{p2colset 8 10 10 2}{...}
{p2col:-}You want to increase the forecast horizon (option {opt step()}).{p_end}
{p2col:-}You want to replace bootstrapped standard errors by ones that are based on a higher number of replications.{p_end}
{p2colreset}{...}

{pstd}
Depending on what you are doing, you may have to erase parts of the DS results before you can replace them with new values.
You can do so with {help dsimih drop}.
{cmd:dsimih create} will prompt you to use {cmd:dsimih drop} and not take any action if your {cmd:dsimih create} statement does not imply a longer forecast horizon for any regimes in {it:rgmlist}.
If only part of the regimes in {it:rgmlist} will receive a longer forecast horizon, DS results for those regimes only are updated.

{marker matsizeissues}{...}
{title:Matsize issues}

{pstd}
Before creating DS results, {cmd:dsimih create} calculates how many rows of a matrix or of a data set are necessary to store results.
If this number is above your current {help matsize} setting, {cmd:dsimih create} aborts with an informative error message.
In these cases, you can increase your {cmd:matsize} setting accordingly and re-run the {cmd:dsimih create} statement.
Should your {help flavors:Stata flavor} not allow to increase the {cmd:matsize} sufficiently, you must re-run the {cmd:dsimih create} statement using the {opt saving()} option.
In this case results will only be available in the saved file but not in {cmd:e()}.

{marker estimationdatasetrequirements}{...}
{title:Estimation data set requirements}

{pstd}
If options {opt bs} and {opt bsp} are not used, {cmd:dsimih create} does not require the data set used in estimation, nor does it require that {cmd:e(sample)} be set appropriately.
By contrast, if you use either option {opt bs} or option {opt bsp}, {cmd:dsimih create} needs to construct bootstrap data samples, and for that both the data set used in estimation as well as {cmd:e(sample)} are necessary.
In addition, the time variable must be set correctly (see {help tsset}).

{marker computationalissues}{...}
{title:Computational issues}

{pstd}
While bootstrap procedures are often recommended in the literature for creating SIRF/SFEVD error bands, they do have downsides.
One example are numerical difficulties that may occur.
A prominent example for SVARs is that the signs of individual columns of model matrices may switch.
While this just changes the interpretation of the sign of the shock if this occurs for your coefficient estimates,
it does invalidate the calculation of bootstrap standard errors when some of the bootstrap samples show this kind of reversal of signs.
{cmd:svarih} may be more susceptible to this than {cmd:svar} since its models contain a larger number of parameters, so numerical difficulties are more likely to occur.
To deal with this, {cmd:dsimih create} provides the option {opt fromb}.
It causes the ML maximization to start from the coefficient estimates instead from standard starting values.
In many cases it is an effective means to prevent sign reversals.
To check whether sign reversals occur, you can utilize option {opt bsbmat}.

{pstd}
Another difficulty consists in deciding whether estimates based on one particular bootstrap sample should be counted as valid.
In {cmd:dsimih create}, bootstrap coefficient estimates are only counted as successful if the optimization did not fail, parameters pass the local identification check (methods IH-BAC and IH-BFA only) and ML convergence was declared.
If the {cmd:svarih} subcommand in question uses a nested GLS iteration, declaration of GLS convergence is also a prerequisite for a replication to be included in the calculation of standard errors.
In all other cases the bootstrap coefficient estimates are discarded.
This means that the effective number of replications that go into the calculation of bootstrap standard errors may below the number supplied in option {opt reps()}.
If you have a highly and difficult-to-maximize model, the number of effective (successful) replications may be substantially below the requested number of replications.
Therefore, usage of option {opt nodots} when calculating bootstrap standard errors is discouraged since its output gives an impression of how well the bootstrap works.
When you save {cmd:dsimih} results in {cmd:e()}, matrices e(dsimih_bs) and e(dsimih_bsp) provide a record of successful, failed, non-convergent, and not-identified replications.
Usage of option {opt bootstrap} of {cmd:dsimih describe} will display this information.

{pstd}
If you are in the situation that many bootstrap replications fail, you can re-run the bootstrap using option {opt verbose} and a low number of {opt reps()}.
{opt verbose} causes {cmd:dsimih create} to display the output of any ML and GLS iterations performed.
By default, it also outputs the estimated coefficients for each replication.
You can suppress the latter output using option {opt notable}.
The output so produced may give you hints as to why bootstrap replications fail.

{pstd}
Yet another downside of bootstrapped standard errors is that calculating them is time-consuming for larger models and for a large number of replications.
For a large model, Stata may well be busy for an hour until a sufficient number of replications have been calculated.
Therefore, the suggested workflow for using {cmd:dsimih create} is to use asymptotic standard errors for interactive work sessions and to cross-check them from time to time against bootstrap error bands.

{pstd}
Asymptotic standard errors are typically calculated much quicker than bootstrap ones.
They are produced almost instantly for smaller values of {it:step}.
Unfortunately, the order of the algorithm that calculates asymptotic standard errors is quadratic so the calculations eventually can become very slow.
To give you an idea what you can roughly expect, many models will have asymptotic standard error calculation times of a few seconds for {it:step}=20-50 and may take half a minute for {it:step}=70-80.
They may become less suitable for interactive work beyond {it:step}=100.
These values obviously depend on your computer, the Stata flavor, and other things.
{cmd:dsimih create} by default displays dots for each {it:step} calculated so you know how quickly calculations proceed.

{pstd}
Option {opt modelstats} of {cmd:dsimih describe} displays information on the {cmd:svarih} model that is most relevant for the calculation time of DS standard errors.

{marker settingtheseed}{...}
{title:Setting the seed}

{pstd}
When creating bootstrapped standard errors, the exact outcome depends on the state of the seed for the random number generator at the time {cmd:dsimih create} was invoked.
Results may also depend on the version of the random number generator used.
See {help set seed}.
While results should not differ qualitatively for the same statement run from different states of the seed when using a sufficiently large number for {opt reps()},
it is imperative to set the seed systematically if exact replicability of results is of importance to you.

{pstd}
If you want to make your bootstrap results exactly reproducible, it is your responsibility to augment your do-files with appropriate {cmd:set seed} statements.
In the case of {cmd:dsimih create}, you need to be a little careful, since you can create, drop, replace and add calculations to {cmd:dsimih} results.
Suppose that you have estimated a model with regime encodings 1 and 2 and you generate DS results with standard errors from a residual bootstrap by executing

{pmore}
{cmd:. version 11.2: set seed 123456}{break}
{cmd:. dsimih create, bs reps(500) step(10)}

{pstd}
{cmd:dsimih create} generates 500 bootstrap samples and then calculates the DS statistics for both regimes, on the same bootstrap samples.
Let's assume you decide to increase the forecast horizon for regime 2.

{pmore}
{cmd:. version 11.2: set seed 123456}{break}
{cmd:. dsimih create, bs reps(500) step(20) regime(2)}

{pstd}
The results for forecast steps 0-10 of regime 2 will be identical to what you had obtained previously since {cmd:dsimih create} generated 500 identical bootstrap samples.
A problem would have occurred if you had not preceeded the second {cmd:dsimih create} statement with a statement that set the seed to the appropriate state.
Then you would have ended up with results for regimes 1 and 2 that are not strictly comparable because they would not be based on identical bootstrap samples.

{pstd}
If you decided to compare results from the residual bootstrap (option {opt bs}) to results from a parametric bootstrap (option {opt bsp}) by issuing

{pmore}
{cmd:. dsimih create, bsp reps(500) step(20)}

{pstd}
it would not matter that the random number generator was at another or unknown state.
You could still compare your {opt bs} results to your {opt bsp} results, since the method for drawing from the residual distribution is both conceptionally and computationally different.
Still, in order to keep things orderly and managable, it is recommended that you set the seed each time before you issue a {cmd:dsimih create} statement that resorts to bootstrap methods.


{marker examples}{...}
{title:Examples}

{pstd}
Excecuting the following statements will change current {cmd:e()}-results.

{pstd}
Bootstrap replication numbers are set to values that are inappropriate for analysis but appropriate for quick execution of example statements.

{pstd}
We will make frequent use of {cmd:dsimih describe}, which describes both {cmd:svarih} estimation results as well as {cmd:dsimih} results. See {help dsimih describe}

{pstd}
Generate example estimates (see {help svarih examples}):

{phang2}{stata webuse lutkepohl2:. webuse lutkepohl2}{p_end}
{phang2}{stata svarih examples bac_first , ereplace:. svarih examples bac_first , ereplace}{p_end}
{phang2}{stata dsimih describe , modelstats:. dsimih describe , modelstats}{p_end}

{pstd}
Create SIRFs and SFEVDs with asymptotic standard errors (the default):

{phang2}{stata dsimih create , step(12):. dsimih create , step(12)}{p_end}
{phang2}{stata dsimih describe:. dsimih describe}{p_end}

{pstd}
Add residual bootstrap standard errors. We set the seed!

{phang2}{stata "version 11.2: set seed 123456":. version 11.2: set seed 123456}{p_end}
{phang2}{stata dsimih create , bs fromb step(12) reps(10):. dsimih create , bs fromb step(12) reps(10)}{p_end}
{phang2}{stata dsimih describe , bootstrap:. dsimih describe , bootstrap}{p_end}

{pstd}
Trying to recreate numbers that already exist will not execute.

{phang2}{stata dsimih create , step(12):. dsimih create , step(12)}{p_end}
{phang2}{stata dsimih create , step(18) regime(2):. dsimih create , step(18) regime(2)}{p_end}
{phang2}{stata dsimih describe:. dsimih describe}{p_end}

{pstd}
It is important to store or save estimates before replacing results in {cmd:e()}. Otherwise they are lost.

{phang2}{stata estimates store bac_first:. estimates store bac_first}{p_end}

{pstd}
Moving on to different estimates:

{phang2}{stata svarih examples llu_first , ereplace:. svarih examples llu_first , ereplace}{p_end}
{phang2}{stata dsimih describe , modelstats:. dsimih describe , modelstats}{p_end}

{pstd}
Horizons of {it:stats} can differ across regimes.
Horizons of standard errors can differ across {it:setypes} and regimes.
In particular, they can be lower than the horizons for the {it:stats}.

{phang2}{stata dsimih create , step(12):. dsimih create , step(12)}{p_end}
{phang2}{stata dsimih create , step(24) nose:. dsimih create , step(24) nose}{p_end}
{phang2}{stata dsimih describe:. dsimih describe}{p_end}
{phang2}{stata estimates store llu_first:. estimates store llu_first}{p_end}

{pstd}
We are now in a postition to display and analyze the DS statistics.

{phang2}{stata estimates restore bac_first:. estimates restore bac_first}{p_end}
{phang2}{stata dsimih describe , modelstats:. dsimih describe , modelstats}{p_end}
{phang2}{stata dsimih table sfevd, impulse(*inc) regime(1) step(1/3 6 12):. dsimih table sfevd, impulse(*inc) regime(1) step(1/3 6 12)}{p_end}

{phang2}{stata estimates restore llu_first:. estimates restore llu_first}{p_end}
{phang2}{stata dsimih describe , modelstats:. dsimih describe , modelstats}{p_end}
{phang2}{stata dsimih graph sirf, impulse(*inv) ustep(10) byopts(rows(2) yrescale) level(68) name(dsimih_gr1, replace):. dsimih graph sirf, impulse(*inv) ustep(10) byopts(rows(2) yrescale) level(68) name(dsimih_gr1, replace)}{p_end}

{pstd}
The following command requires a matsize setting of 882, which Stata/IC users do not have. We therefore save the results in a {help dsimih file}.

{phang2}{stata dsimih create , step(48) nose saving(dsimih_examplefile.dta, replace):. dsimih create , step(48) nose saving(dsimih_examplefile.dta, replace)}{p_end}

{pstd}
If your current matsize setting is below 882, results in {cmd:e()} remained the same.
Otherwise the results from the last {cmd:dsimih create} run have been added to {cmd:e()}.
The saved file only contains the results generated by the statement containing the {opt saving()} option.

{phang2}{stata dsimih describe:. dsimih describe}{p_end}
{phang2}{stata dsimih describe using dsimih_examplefile.dta:. dsimih describe using dsimih_examplefile.dta}{p_end}

{pstd}
The file saved by the {opt saving()} option is a {help dsimih_etodta##dsimihfiles:dsimih file}.
All {cmd:dsimih} subcommands for results analysis have a {opt using} modifier that lets you access these files.

{phang2}{stata dsimih graph sirf using dsimih_examplefile, imp(*inc) reg(1) noci name(dsimih_gr2, replace) :. dsimih graph sirf using dsimih_examplefile, imp(*inc) reg(1) noci name(dsimih_gr2, replace) }{p_end}

{phang2}{stata erase dsimih_examplefile.dta:. erase dsimih_examplefile.dta}{p_end}


{marker savedresults}{...}
{title:Saved results}

{pstd}
If allowed by your {help matsize} setting, {cmd:dsimih create} adds or modifies the following in {cmd:e()}:

{synoptset 20 tabbed}{...}
{p2col 5 20 24 0: Matrices}{p_end}
{synopt:{cmd:e(dsimih)}}matrix of dynamic simulation results{p_end}
{synopt:}{p_end}
{synopt:according to usage of option {opt bs} or {opt bsp}:}{p_end}
{synopt:{cmd:e(dsimih_bs)}}detail for bootstrap replications for the residual bootstrap{p_end}
{synopt:{cmd:e(dsimih_bsp)}}detail for bootstrap replications for the parametric bootstrap{p_end}
{p2colreset}{...}


{marker author}{...}
{title:Author}

{phang}
Daniel C. Schneider, Goethe University Frankfurt, dan_schneider@outlook.com


{marker acknowledgements}{...}
{title:Acknowledgements}

{pstd}
The code of official Stata's {cmd:irf create} has served as a point of reference throughout the development of {cmd:dsimih create}.
Any remaining errors in {cmd:dsimih create} are mine.


{marker alsosee}{...}
{title:Also see}

{psee}
Help:
{helpb irf:[TS] irf},
{helpb dsimih},
{helpb dsimih table},
{helpb dsimih graph},
{helpb dsimih describe},
{helpb dsimih use},
{helpb dsimih drop},
{helpb dsimih etodta}
{p_end}

